import 'package:flutter/cupertino.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:percent_indicator/circular_percent_indicator.dart';

import 'package:admin_desktop/infrastructure/services/app_helpers.dart';
import 'package:admin_desktop/presentation/styles/style.dart';

class StatisticPercentWidget extends StatelessWidget {
  final num? percent;
  final String status;

  const StatisticPercentWidget(
      {super.key, required this.percent, required this.status});

  @override
  Widget build(BuildContext context) {
    return Padding(
      padding: REdgeInsets.only(right: 56),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Row(
            mainAxisAlignment: MainAxisAlignment.start,
            children: [
              Container(
                height: 14,
                width: 14,
                decoration: BoxDecoration(
                  color: AppHelpers.getStatusColor(status),
                  shape: BoxShape.circle,
                ),
              ),
              6.horizontalSpace,
              Text(
                AppHelpers.getTranslation(status),
                style: Style.interNormal(),
              ),
              // 15.horizontalSpace,
            ],
          ),
          48.verticalSpace,
          Container(
            height: 100,
            width: 100,
            decoration: BoxDecoration(
              shape: BoxShape.circle,
              color: AppHelpers.getStatusColor(status).withOpacity(0.2),
            ),
            child: CircularPercentIndicator(
              radius: 48,
              lineWidth: 8,
              percent: (percent?.floor() ?? 0) / 100,
              center:
                  Text("${percent?.floor() ?? 0}%", style: Style.interNormal()),
              progressColor: AppHelpers.getStatusColor(status),
              backgroundColor: Style.transparent,
              circularStrokeCap: CircularStrokeCap.round,
              rotateLinearGradient: true,
            ),
          ),
        ],
      ),
    );
  }
}
